//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(BASE_INTERNAL_MACROS_H)
#define BASE_INTERNAL_MACROS_H

#include <Candera/System/MetaInfo/TypeAggregator.h>
#include <Candera/System/MetaInfo/DataType.h>

/*  ----------------------------------------------------------------------------
    Internal macros
    ---------------------------------------------------------------------------- */

/**
 *  Internal macro - empty macro
 */
#define _CdaNothing

/**
 *  Internal macro - construct a file level unique name
 *  @param prefix prefix to the name
 *  @return unique name with given prefix
 */
#define _CdaUniqueName(prefix) FEATSTD_CONCAT2(prefix, __LINE__)

#define _CdaStaticAggregationProlog(aggregationName, aggregatableBaseType) \
    struct aggregationName { \
        typedef aggregatableBaseType AggregationItemBaseType; \
        struct ItemAggregation {

#define _CdaStaticAggregation(typeName) \
            FEATSTD_LINT_NEXT_EXPRESSION(1516, "Member declaration hides inherited member [MISRA C++ Rule 2-10-2] - false positive, the name is not required and collisions of the generated name are not relevant!") \
            Candera::MetaInfo::Internal::AggregationInstanceRef<typeName> _CdaUniqueName(Item);

#define _CdaStaticAggregationEpilog(aggregationName, typenameSubstitute) \
        }; \
        typedef Candera::MetaInfo::Internal::StaticAggregation<AggregationItemBaseType, ItemAggregation > Aggregation; \
    }; \
    _CdaEnumeratorInterface(aggregationName::Aggregation, typenameSubstitute::Aggregation)

/**
 *  Internal macro - defines prologue for an aggregation
 *  @param aggregationName name of the aggregation (e.g. Properties)
 *  @param aggregatableBaseType common base type of the aggregation
 *         items items (e.g. WidgetPropertyMetaInfo)
 *  @param inheritedAggregation aggregation defined in the base class which
 *         should be included in the aggregation
 */
#define _CdaAggregationProlog(aggregationName, aggregatableBaseType, inheritedAggregation, initializationItems) \
    struct aggregationName { \
        initializationItems \
        typedef aggregatableBaseType AggregationItemBaseType; \
        typedef inheritedAggregation

#define _CdaAggregation(typeName) \
            FEATSTD_LINT_NEXT_EXPRESSION(1516, "Member declaration hides inherited member [MISRA C++ Rule 2-10-2] - false positive, the name is not required and collisions of the generated name are not relevant!") \
            _CdaUniqueName(Aggregation); \
        typedef Candera::MetaInfo::TypeAggregator<_CdaUniqueName(Aggregation), Candera::MetaInfo::Aggregatable<typeName, AggregationItemBaseType> >

/**
 *  Internal macro - defines aggregation epilogue
 *  Closes the aggregation collection type and defines the access functions
 *  to the aggregation
 *  @param aggregationName name of the aggregation
 *  @param typenameSubstitute modifier used with template aggregations
 */
#define _CdaAggregationEpilog(aggregationName, typenameSubstitute) \
        ItemAggregation; \
        typedef Candera::MetaInfo::AggregationContainer<ItemAggregation, AggregationItemBaseType> Aggregation; \
    }; \
    _CdaEnumeratorInterface(aggregationName::Aggregation, typenameSubstitute::Aggregation)

/**
 *  Internal macro - use this macro to put Aggregatable as type into _CdaTypedefAggregator
 *  @param type1 first aggregation type
 *  @param type1 second aggregation type
 */
#define _CdaAggregatable(type1, type2) \
    Candera::MetaInfo::Aggregatable< type1 , type2 >

/**
 *  Internal macro - defines TypeAggregator and shortens the type name
 *  @param type1 first aggregation type
 *  @param type1 second aggregation type
 */
FEATSTD_LINT_MACRO(1942, _CdaTypedefAggregator, "MISRA C++ Rule 14-6-1 - Remove after rework")
#define _CdaTypedefAggregator(type1, type2) \
    FEATSTD_LINT_NEXT_EXPRESSION(1516, "Member declaration hides inherited member [MISRA C++ Rule 2-10-2] - false positive, the name is not required and collisions of the generated name are not relevant!") \
    typedef Candera::MetaInfo::TypeAggregator< type1, type2 > _CdaUniqueName(TypeAggregatorBase); \
    FEATSTD_LINT_NEXT_EXPRESSION(1516, "Member declaration hides inherited member [MISRA C++ Rule 2-10-2] - false positive, the name is not required and collisions of the generated name are not relevant!") \
    typedef struct _CdaUniqueName(TypeAggregator) : public _CdaUniqueName(TypeAggregatorBase) { \
        typedef _CdaUniqueName(TypeAggregatorBase) TypeAggregator; \
    }

/**
 *  Internal macro - defines enumerator interface for an aggregation type
 *  @param containerType typed AggregationContainer type name
 *  @param typenameSubstitute modifier used with template aggregations
 */
#define _CdaEnumeratorInterface(containerType, typenameSubstitute) \
    virtual Candera::Int32 GetItemCount() const { return containerType::Count(); } \
    virtual typenameSubstitute::ItemType* LookupItem(const Candera::Char *name) const { return containerType::Lookup(name); } \
    virtual typenameSubstitute::ItemType* GetItem(Candera::Int32 idx) const { return containerType::Item(idx); }

/**
 *  Internal macro - prologue to an item in the surrounding aggregation
 *  @param typeName name of the type to be aggregated
 */
#define _CdaAggregationItemProlog(typeName) \
    FEATSTD_LINT_NEXT_EXPRESSION(1516, "Member declaration hides inherited member [MISRA C++ Rule 2-10-2] - false positive, the name is not required and collisions of the generated name are not relevant!") \
    _CdaUniqueName(Aggretion); \
    typedef class Cda_##typeName : public AggregationItemBaseType { \
    public: \
        _CdaTypedefAggregator(_CdaUniqueName(Aggretion), _CdaAggregatable(Cda_##typeName, AggregationItemBaseType)) TypeForwarder; \
        Cda_##typeName() : AggregationItemBaseType(FEATSTD_STRINGIZE(typeName)) { } \
        /* next line is to avoid compiler warning "overloaded virtual function ... is only partially overridden in class..." */ \
        using AggregationItemBaseType::Set;

/**
 *  Internal macro - epilogue for an aggregated item
 *  closes the definition of an item in an aggregation
 *  @param typenameSubstitute modifier used with template aggregations
 */
#define _CdaAggregationItemEpilog(typenameSubstitute) \
        FEATSTD_LINT_NEXT_EXPRESSION(1516, "Member declaration hides inherited member [MISRA C++ Rule 2-10-2] - false positive, the name is not required and collisions of the generated name are not relevant!") \
    } _CdaUniqueName(AggregationItem); \
    typedef typenameSubstitute _CdaUniqueName(AggregationItem)::TypeForwarder

#endif
