//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LINE_H)
#define CANDERA_LINE_H

#include <Candera/Environment.h>
#include <Candera/System/Mathematics/Vector3.h>

namespace Candera {

    /** @addtogroup MathematicsSystem
     *  @{
     */

    /**
     * @brief   A Line in 3D space. A Line has a defined starting and a end point.
     */
    class Line
    {
    public:
        /**
         *  Constructor
         */
        Line();

        /**
         *  Destructor
         */
        ~Line(); // non-virtual
        
        // default copy constructor is fine

        /**
         *  Constructs a Line object out of two vectors describing starting and end point.
         *  @param  start  A Vector3 which describes the starting point of the Line in 3d space.  
         *  @param  end    A Vector3 which describes the end point of the Line in 3d space.  
         */
        Line(const Vector3& start, const Vector3& end);

        /**
         *  Set the Start point of the line
         *  @param start The start point of the line that is set.
         */
        void SetStart(const Vector3& start) { m_start = start; }

        /**
         *  Retrieves the start point of the line.
         *  @return The start point of the line.
         */
        const Vector3& GetStart() const { return m_start; }

        /**
         *  Set the end point of the line.
         *  @param end The end point of the line.
         */
        void SetEnd(const Vector3& end) { m_end = end; }

        /**
         *  Retrieves the end point of the line.
         *  @return The end point of the line.
         */
        const Vector3& GetEnd() const { return m_end; }

    private:
        Vector3 m_start;
        Vector3 m_end;
    };

    /** @} */ // end of MathematicsSystem

} // namespace Candera

#endif// CANDERA_LINE_H
