//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_LOCALIZER_H)
    #define CANDERA_GLOBALIZATION_LOCALIZER_H

#include <Candera/Environment.h>
#include <Candera/System/GlobalizationBase/Culture.h>
#include <Candera/System/GlobalizationBase/Localizable.h>

namespace Candera { namespace Globalization {

        /** @addtogroup CanderaGlobalizationCulture
         *  @{
         */

        /**
         *  Localizer
         */
        class Localizer {
            public:
                /**
                 *  Specifies the text type.
                 */
                enum TextType {
                    FEATSTD_LINT_CURRENT_SCOPE(578, "hides Candera::Globalization::_undefined. little impact as class local, not changed to maintain interface compatibility.")
                    _undefined          = 0,    ///< Undefined

                    SimpleText          = 1,    ///< Text with a constant string per language.
                    ParameterizedText   = 2     ///< Text that can have placeholders which are replaced by variable values during runtime.
                };

                FEATSTD_TYPEDEF_SHARED_POINTER(Localizer);

                Localizer() {};
                virtual ~Localizer() {} ;

                /**
                 *  @brief Will be called by the CultureManager whenever the current culture is changed.
                 *  This triggers the DefaultLocalizer to load the corresponding language pack from the asset.
                 *  @param  culture     The new culture.
                 */
                virtual void SetCurrentCulture(Culture::SharedPointer culture) = 0;

                /**
                 *  @brief Retrieves the localized base string for the given string ID.
                 *  @param  id      The ID which specifies the localized string.
                 *  @return         The base string for the given string ID.
                 */
                virtual const TChar* GetTextBaseString(LocalizableId id) const = 0;

                /**
                 *  @brief Retrieves the #TextType for the given string ID.
                 *  @param  id      The ID which specifies the localized string.
                 *  @return         The text type for the given string ID.
                 */
                virtual TextType GetTextType(LocalizableId id) const = 0;

        private:
            // Make this class manageable by MemoryManagement::SharedPointer
            CANDERA_SHARED_POINTER_DECLARATION();
        };

        /// @}

    }   // namespace Globalization
}   // namespace Candera

#endif  // CANDERA_GLOBALIZATION_LOCALIZER_H
