//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_METAINFO_CULTUREDATATYPE_H)
    #define CANDERA_METAINFO_CULTUREDATATYPE_H

#include <Candera/System/MetaInfo/DataType.h>
#include <Candera/System/GlobalizationBase/Culture.h>

namespace FeatStd {
    namespace MemoryManagement {
        template <class T>
        class SharedPointer;
    }
}
namespace Candera {

    namespace MetaInfo {

        /** @addtogroup DataTypesBase
         *  @{
         */

        /**
         * @brief DataType specialization for Culture::SharedPointer.
         *
         * The string representation of a Culture::SharedPointer consists of
         *  - text direction
         *  - locale
         *  separated by semicolons, e.g. "1;en".
         *
         *  @see Candera::Globalization::TextDirection
         */
        template<> struct DataType<Candera::Globalization::Culture::SharedPointer> {

            static bool ConvertToString(const Candera::Globalization::Culture::SharedPointer& culture, Char* buf, UInt bufLen);

            static bool ConvertFromString(Candera::Globalization::Culture::SharedPointer& culture, const Char* buf);

            static const Char* GetEditor() { return "builtin://CultureEditor"; }
        };

        /**
         * @} //end of DataTypesBase
         */

    }   // namespace MetaInfo
}   // namespace Candera

#endif  // CANDERA_METAINFO_CULTUREDATATYPE_H
