//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ComponentSystem.h"

#include <Candera/System/EntityComponentSystem/EntitySystem.h>

namespace Candera {

namespace EntityComponentSystem
{

    FEATSTD_RTTI_BASECLASS_DEFINITION(AbstractComponentSystem)

AbstractComponentSystem::AbstractComponentSystem()
    :
    m_wasCreatedbyEntitySystem(false),
    m_priority(0.0F),
    m_isEnabled(true)
{
}

void AbstractComponentSystem::SetPriority(Float priority)
{
    m_priority = priority;
    EntitySystem::OnComponentSystemPriorityChanged();
}

bool AbstractComponentSystem::AttachComponentTo(const Entity* entity, const UInt32 handle, const TypeId typeId) const
{
    FEATSTD_DEBUG_ASSERT(m_wasCreatedbyEntitySystem); // A component system must be created using EntitySystem::Create().
    return EntitySystem::AttachComponent(entity, handle, typeId);
}

bool AbstractComponentSystem::DetachComponentFrom(const Entity* entity, const UInt32 handle, const TypeId typeId) const
{
    FEATSTD_DEBUG_ASSERT(m_wasCreatedbyEntitySystem); // A component system must be created using EntitySystem::Create().
    return EntitySystem::DetachComponent(entity, handle, typeId);
}

}

}
