//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_OVERLAY_LAYOUTER_H)
#define CANDERA_OVERLAY_LAYOUTER_H

#include <Candera/EngineBase/Layout/Layouter.h>

namespace Candera {
/** @addtogroup Layout
 *  @{
 */

    /**
     *  @brief OverlayLayouter sets sizes of all child elements to fulfill the given area.
     */
    class OverlayLayouter : public Candera::Layouter {
        public:
            virtual ~OverlayLayouter() override;

            /**
            *  Gets the instance of this class.
            *  @return A pointer to the instance of this class.
            */
            static OverlayLayouter* GetInstance();

            /**
             *  This is a singleton so dispose does nothing.
             */
            virtual void Dispose() override {}

            // overrides Layouter::Clone
            virtual Layouter* Clone() const override { return GetInstance(); }

    protected:
        /**
        *  This method is called as first layout pass to collect all the data which is needed to layout the child nodes.
        *  @param node The node which child nodes shall be layouted.
        *  @param clientArea Area where layout shall be applied.
        *  @return Vector describing height and width of whole layouted rectangle.
        */
            virtual Candera::Vector2 OnMeasure(const AbstractNodePointer& node, const Candera::Vector2& clientArea) override;

            /**
            *  This method is called as second layout pass to arrange the child nodes (position and scale).
            *  @param node Node which children shall be arranged.
            *  @param clientArea Rectangle where layout shall be applied.
            */
            virtual void OnArrange(const AbstractNodePointer& node, const Candera::Rectangle& clientArea) override;

            OverlayLayouter();
            OverlayLayouter(const OverlayLayouter&);

        private:
            CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1704, CANDERA_LINT_REASON_NONCOPYABLE)
    };
}

 /** @} */ // end of Layout

#endif // CANDERA_OVERLAY_LAYOUTER_H
