//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ENGINEBASE_H)
#define CANDERA_ENGINEBASE_H

// Animation
#include <Candera/EngineBase/Animation/AbstractEasingFunction.h>
#include <Candera/EngineBase/Animation/AnimationBlendedProperty.h>
#include <Candera/EngineBase/Animation/AnimationController.h>
#include <Candera/EngineBase/Animation/AnimationGroupPlayer.h>
#include <Candera/EngineBase/Animation/AnimationKeyframeSequence.h>
#include <Candera/EngineBase/Animation/AnimationPlayer.h>
#include <Candera/EngineBase/Animation/AnimationPlayerBase.h>
#include <Candera/EngineBase/Animation/AnimationPlayerListener.h>
#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/EngineBase/Animation/AnimationTimeDispatcher.h>
#include <Candera/EngineBase/Animation/AnimationTimeType.h>
#include <Candera/EngineBase/Animation/BackEaseFunction.h>
#include <Candera/EngineBase/Animation/BezierInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/BounceEaseFunction.h>
#include <Candera/EngineBase/Animation/CameraGroupAnimationPropertySetter.h>
#include <Candera/EngineBase/Animation/EaseInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/ElasticEaseFunction.h>
#include <Candera/EngineBase/Animation/ExponentialEaseFunction.h>
#include <Candera/EngineBase/Animation/InterpolationStrategy.h>
#include <Candera/EngineBase/Animation/KeyframeSequence.h>
#include <Candera/EngineBase/Animation/LinearInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/PowerEaseFunction.h>
#include <Candera/EngineBase/Animation/RelativePropertySetter.h>
#ifdef CANDERA_SCRIPTING_ENABLED
#include <Candera/EngineBase/Animation/ScriptParameterAnimationPropertySetter.h>
#endif
#include <Candera/EngineBase/Animation/SplineInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/StepInterpolationStrategy.h>

//Cloning
#include <Candera/EngineBase/Cloning/MappedSharedObjectCloneStrategy.h>
#include <Candera/EngineBase/Cloning/SharedObjectCloneStrategy.h>
#include <Candera/EngineBase/Cloning/TreeClonerBase.h>
#include <Candera/EngineBase/Cloning/TreeCloneStrategy.h>
#include <Candera/EngineBase/Cloning/TreeMatchBase.h>

// Common
#include <Candera/EngineBase/Common/Alignment.h>
#include <Candera/EngineBase/Common/Bitmap.h>
#include <Candera/EngineBase/Common/BitmapAtlas.h>
#include <Candera/EngineBase/Common/BitmapGlyphCacheAccess.h>
#include <Candera/EngineBase/Common/BitmapTextRenderContext.h>
#include <Candera/EngineBase/Common/CameraGroup.h>
#include <Candera/EngineBase/Common/CanderaObject.h>
#include <Candera/EngineBase/Common/Color.h>
#include <Candera/EngineBase/Common/Enums.h>
#include <Candera/EngineBase/Common/GlyphAtlas.h>
#include <Candera/EngineBase/Common/ScopeMask.h>
#include <Candera/EngineBase/Common/ScopeMaskSearchCriterion.h>
#include <Candera/EngineBase/Common/SearchCriterion.h>
#include <Candera/EngineBase/Common/SearchTreeTraverser.h>
#include <Candera/EngineBase/Common/StringIdentifier.h>
#include <Candera/EngineBase/Common/TreeIterator.h>
#include <Candera/EngineBase/Common/TreeTraverserBase.h>

//DataTypes
#include <Candera/EngineBase/DataTypes/CanderaObjectDataType.h>
#include <Candera/EngineBase/DataTypes/ColorDataType.h>

// Dynamic Properties
#include <Candera/EngineBase/DynamicProperties/DynamicProperty.h>
#include <Candera/EngineBase/DynamicProperties/DynamicPropertyBase.h>
#include <Candera/EngineBase/DynamicProperties/DynamicPropertyHost.h>
#include <Candera/EngineBase/DynamicProperties/DynamicPropertyRegistry.h>
#include <Candera/EngineBase/DynamicProperties/DynamicPropertyRegistryBase.h>
#include <Candera/EngineBase/DynamicProperties/DynamicPropertySpecification.h>
#include <Candera/EngineBase/DynamicProperties/TypeInfo.h>
#include <Candera/EngineBase/DynamicProperties/ValueNode.h>
#include <Candera/EngineBase/DynamicProperties/ValueNodeBase.h>

#endif  // CANDERA_ENGINEBASE_H
