//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DynamicProperties_TypeInfo_H)
#define CANDERA_DynamicProperties_TypeInfo_H

#include <Candera/Environment.h>

namespace Candera {
    /**
        *  provides basic type information on given type
        *  @param T type to supply information from
        */
    template<typename ValueType> struct TypeInfo {
        /**
            *  defines the const call by reference signature
            */
        typedef const ValueType& ConstRefType;

        /**
            *  defines the call by reference signature
            */
        typedef ValueType& RefType;

        /**
            *  defines the default value for the type in dynamic properties
            *  @return The default value for the type in dynamic properties.
            */
        static ValueType GetDefaultValue();
    };

    template<typename ValueType>
    inline ValueType TypeInfo<ValueType>::GetDefaultValue()
    {
        return ValueType();
    }

    /**
        *  defines TypeInfo for standard integral types. only to be used in global namespace.
        *  @param type The type to define the type information for.
        *  @param defaultValue The default value to use for type.
        */
#define CdaDefPrimitiveTypeInfo(type, defaultValue)    \
    namespace Candera { \
        template<> struct TypeInfo<type> {    \
            typedef type ConstRefType;    \
            typedef type RefType;    \
            static type GetDefaultValue(); \
        }; \
        inline type TypeInfo<type>::GetDefaultValue() \
        { \
            return defaultValue; \
        } \
    }

    // Pointer types are primitive.
    template<typename T> struct TypeInfo<T*> {
        typedef T* ConstRefType;
        typedef T* RefType;
        static T* GetDefaultValue();
    };

    template<typename T>
    inline T* TypeInfo<T*>::GetDefaultValue()
    {
        return 0;
    }

}    // namespace Candera

CdaDefPrimitiveTypeInfo(bool, false)
CdaDefPrimitiveTypeInfo(Char, 0)
CdaDefPrimitiveTypeInfo(Int8, 0)
CdaDefPrimitiveTypeInfo(UInt8, 0)
CdaDefPrimitiveTypeInfo(Int16, 0)
CdaDefPrimitiveTypeInfo(UInt16, 0)
CdaDefPrimitiveTypeInfo(Int32, 0)
CdaDefPrimitiveTypeInfo(UInt32, 0)
CdaDefPrimitiveTypeInfo(Float, 0.0F)

#endif    // !defined(CANDERA_DynamicProperties_TypeInfo_H)
