//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DynamicPropertyRegistryBase.h"
#include <Candera/EngineBase/DynamicProperties/DynamicPropertyBase.h>
#include <CanderaPlatform/OS/StringPlatform.h>

namespace Candera  { namespace DynamicProperties {
PropertyHierarchyNode *DynamicPropertyRegistryBase::m_registeredHierarchyNodes = 0;
PropertyHierarchyNode *DynamicPropertyRegistryBase::m_lastFoundHierarchyNode = 0;

PropertyHierarchyNode::PropertyHierarchyNode() :
    m_parent(0),
    m_properties(0),
    m_nextRegistered(DynamicPropertyRegistryBase::GetRegisteredHierarchyNodes())
{
    DynamicPropertyRegistryBase::SetRegisteredHierarchyNodes(this);
}

void PropertyHierarchyNode::Register(DynamicPropertyBase *prop)
{
    prop->SetNext(m_properties);
    m_properties = prop;
}

const Char* PropertyHierarchyNode::GetHostTypeName() const
{
    return (m_properties == 0) ? 0 : m_properties->GetHostTypeName();
}

PropertyHierarchyNode *DynamicPropertyRegistryBase::FindHierarchyNode(const Char* hostTypeName)
{
    PropertyHierarchyNode* curHierarchy = GetRegisteredHierarchyNodes();
    while (curHierarchy != 0) {
        const Char* curHostTypeName = curHierarchy->GetHostTypeName();
        if ((curHostTypeName != 0) && (StringPlatform::CompareStrings(curHostTypeName, hostTypeName) == 0)) {
            return curHierarchy;
        }
        curHierarchy = curHierarchy->GetNextRegistered();
    }
    return 0;
}

DynamicPropertyBase* DynamicPropertyRegistryBase::FindProperty(const Char *hostTypeName, const Char *propertyName)
{
    if ((hostTypeName == 0) || (propertyName == 0)) {
        return 0;
    }

    PropertyHierarchyNode* foundHierarchyNode;

    if ((m_lastFoundHierarchyNode != 0) && (StringPlatform::CompareStrings(m_lastFoundHierarchyNode->GetHostTypeName(), hostTypeName) == 0)) {
        foundHierarchyNode = m_lastFoundHierarchyNode;
    }
    else {
        foundHierarchyNode = FindHierarchyNode(hostTypeName);
    }

    if (foundHierarchyNode == 0) {
        return 0;
    }

    DynamicPropertyBase* curProperty = foundHierarchyNode->GetProperties();
    while (curProperty != 0) {
        if (StringPlatform::CompareStrings(curProperty->GetPropertyName(), propertyName) == 0) {
            m_lastFoundHierarchyNode = foundHierarchyNode;
            return curProperty;
        }
        curProperty = curProperty->GetNext();
    }

    return 0;
}
}}
