//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DynamicProperties_DynamicPropertyRegistry_H)
#define CANDERA_DynamicProperties_DynamicPropertyRegistry_H

#include <Candera/EngineBase/DynamicProperties/DynamicPropertyRegistryBase.h>

namespace Candera {
    namespace DynamicProperties {
        /// @addtogroup DynamicPropertiesBase
        /// @{
        class DynamicPropertyBase;

        /**
            * @brief Represents the singleton property registry for a given type.
            */
        template<typename T> 
        class DynamicPropertyRegistry : public DynamicPropertyRegistryBase {
            public:
                /**
                    *  Retrieves the property hierarchy node.
                    *  @return The property hierarchy node.
                    */
                static PropertyHierarchyNode& GetPropertyHierarchy();
        };

        template<typename T>
        PropertyHierarchyNode& DynamicPropertyRegistry<T>::GetPropertyHierarchy()
        {
            static PropertyHierarchyNode node;
            return node;
        }

        /// @}
    }
}
#endif    // !defined(CANDERA_DynamicProperties_DynamicPropertyRegistry_H)
