//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(CANDERA_COLORDATATYPE_H)
#define CANDERA_COLORDATATYPE_H

#include <Candera/System/MetaInfo/DataType.h>
#include <Candera/EngineBase/Common/BaseStringBufferAppenders.h>

namespace Candera {
    class Color;

    namespace MetaInfo {
              
/** @addtogroup DataTypesBase 
 *  @{ 
 */

        /**
         * @brief DataType specialization for Color.
         * 
         * The string representation of a Color consists of the four color components comma separated,
         *  e.g. "1.0,0.0,0.0,0.5", where red = 1.0F, green = 0.0F, blue = 0.0F, alpha = 0.5F.
         */
        template<> struct DataType<Color> {            
            /**
             * Convert a Color to its string representation.
             * 
             * @param val Color to convert.
             * @param buf Buffer to write the string representation.
             * @param bufLen Buffer length.
             * @return true if conversion successful, false otherwise.
             */
            static bool ConvertToString(const Color &val, Char *buf, UInt bufLen);
            
            /**
             * Convert the string representation to a Color.
             * 
             * @param val converted Color.
             * @param buf Buffer that contains the string representation.
             * @return true if conversion successful, false otherwise.
             */
            static bool ConvertFromString(Color &val, const Char *buf);
            
            /**
             * Get the PropertyEditor name as known by SceneComposer.
             * 
             * @return string containing the SceneComposer property editor name.
             */
            static const Char* GetEditor() { return "builtin://ColorEditor"; }
        };        
        
        /**
         * @} //end of DataTypesBase
         */
    }
}

#endif // CANDERA_COLORDATATYPE_H
