//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ColorDataType.h"
#include <Candera/EngineBase/Common/Color.h>

namespace Candera {
    namespace MetaInfo {
        bool DataType<Color>::ConvertToString(const Color &val, Char *buf, UInt bufLen) {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: only inline getter, no side effect")
            Float tab[4] = { val.GetRed(), val.GetGreen(), val.GetBlue(), val.GetAlpha() };
            UInt n = SerializationPlatform::FromBinary(buf, bufLen, ",", tab, tab + 4);
            return n == 4U;
        }

        bool DataType<Color>::ConvertFromString(Color &val, const Char *buf) {
            Float tab[4] = { 0.0F, 0.0F, 0.0F, 0.0F };
            UInt n = SerializationPlatform::ToBinary(buf, ",", tab, tab + 4);
            val = Color(tab[0], tab[1], tab[2], tab[3]);
            return n == 4U;
        }

    }
}

