//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CanderaObjectDataType.h"
#include <Candera/EngineBase/Common/CanderaObject.h>

namespace Candera {
    namespace MetaInfo {
        namespace Internal {

            bool NonCanderaObjectBaseConverterToString::ConvertToString(const void* ptr, Char *buf, UInt bufLen)
            {
                FEATSTD_UNUSED(bufLen);
                buf[0] = '\0';
                return (ptr == 0);
            }


            bool CanderaObjectBaseConverterToString::ConvertToString(const CanderaObject* ptr, Char *buf, UInt bufLen)
            {
                if ((ptr != 0) && (ptr->GetName() != 0)) {
                    StringPlatform::CopyPartial(buf, ptr->GetName(), bufLen);
                    buf[bufLen - 1] = '\0';
                }
                else {
                    buf[0] = '\0';
                }

                return (ptr == 0);
            }
        }
    }
}
