//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_StringIdentifier_H)
    #define CANDERA_StringIdentifier_H

#include <Candera/Environment.h>

#include <Candera/System/Container/LinkedList.h>
#include <Candera/System/MemoryManagement/Disposer.h>

namespace Candera {
    /** @addtogroup CommonBase
     *  @{
     */

    /**
     * String identifier is used to uniquely identify widgets/animations/composites 
     *  within their owner (composite) context. 
     */
    class StringIdentifier {
    public:
        typedef MemoryManagement::ArrayDisposer<const Char*> Disposer;
        typedef Disposer::DisposerFunction DisposerFn;

        StringIdentifier();
        ~StringIdentifier();

        /**
         * Set a string id that is unique in the owner's context.
         *
         * @param id String id.
         * @param disposer String disposer.
         */
        void SetId(const Char* id, DisposerFn disposer);

        /**
         * @return Unique String id.
         */
        const Char* GetId() const { return m_id; }

        /**
         * Set StringIdentifier of object's owner (composite).
         * For composite objects, the identifier must be the identifier of
         *  the CompositeGroup that owns the object. For global objects, the 
         *  identifier must be 0.
         * 
         * @param ownerId identifier Owner's identifier.
         */
        void SetOwner(StringIdentifier* ownerId) { m_owner = ownerId; };

        /**
         * @return Object owner's StringIdentifier
         */
        const StringIdentifier* GetOwner() const { return m_owner; }
    private:
        const Char* m_id;
        DisposerFn m_disposer;
        StringIdentifier* m_owner;

        FEATSTD_MAKE_CLASS_UNCOPYABLE(StringIdentifier);
    };

    /** @} */ // end of CommonBase

} // namespace Candera

#endif  // CANDERA_StringIdentifier_H
