//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "StringIdentifier.h"

namespace Candera {
    
    StringIdentifier::StringIdentifier() : 
        m_id(0), 
        m_disposer(0), 
        m_owner(0)
    {

    }

    StringIdentifier::~StringIdentifier()
    {
        if ((m_id != 0) && (m_disposer != 0)) {
            m_disposer(m_id);
        }

        m_id = 0;
        m_disposer = 0;
    }

    void StringIdentifier::SetId(const Char* id, DisposerFn disposer)
    {
        m_id = id; m_disposer = disposer;
    }

} // namespace Candera
