//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SearchCriterion_H)
    #define CANDERA_SearchCriterion_H

#include <Candera/Environment.h>

namespace Candera {

    /** @addtogroup CommonBase
     *  @{
     */

    /**
     * Abstract interface for search function criterion. The function returns whether the given node
     *  fits the searched criterion or not.
     */
    template <typename T>
    class SearchCriterion {
        public:
            /**
             *  Constructor
             */
            SearchCriterion() {};

            /**
             *  Destructor
             */
            virtual ~SearchCriterion() {};

            /**
             * Validate node.
             *
             * @param node Node to be validated by the implemented criterion.
             * @return true in case the node is valid (meets the searched criterion),
             *      false otherwise.
             */
            virtual bool IsFulfilled(const T& node) const = 0;
    };

    /** @} */ // end of CommonBase

} // namespace Candera

#endif  // CANDERA_SearchCriterion_H
