//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ScopeMaskSearchCriterion_H)
    #define CANDERA_ScopeMaskSearchCriterion_H

#include <Candera/EngineBase/Common/SearchCriterion.h>
#include <Candera/EngineBase/Common/ScopeMask.h>

namespace Candera {

    /** @addtogroup CommonBase
     *  @{
     */

    /**
     * SearchCriterion that validates all nodes that are in a predefined scope.
     */
    template <typename T>
    class ScopeMaskSearchCriterion: public SearchCriterion<T> {
        public:
            /**
             *  Constructor
             */
            ScopeMaskSearchCriterion(ScopeMask scopeMask = ScopeMask()): m_scopeMask(scopeMask) {};

            /**
             *  Destructor
             */
            virtual ~ScopeMaskSearchCriterion() override {};

            /**
             * Set ScopeMask.
             */
            void SetScopeMask(const ScopeMask& scopeMask) { m_scopeMask = scopeMask; }

            /**
             * Get ScopeMask.
             */
            const ScopeMask& GetScopeMask() const { return m_scopeMask; }

            virtual bool IsFulfilled(const T& node) const override;

        private:
            ScopeMask m_scopeMask;
    };
 
    template <typename T>
    bool ScopeMaskSearchCriterion<T>::IsFulfilled(const T& node) const 
    {
        return node.IsInScopeOf(m_scopeMask);
    }
    
    /** @} */ // end of CommonBase

} // namespace Candera

#endif  // CANDERA_ScopeMaskSearchCriterion_H
