//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RESOURCEDATAHANDLE_H)
#define CANDERA_RESOURCEDATAHANDLE_H

#include <Candera/Environment.h>
#include <FeatStd/MemoryManagement/Disposer.h>
#include <CanderaPlatform/OS/MemoryPlatform.h>

namespace Candera {
    /** @addtogroup CommonBase
     *  @{
     */
    
    /**
     * @brief Object that stores information about access to large data buffers.
     */
    struct ResourceDataHandle {
        static const ResourceDataHandle& InvalidHandle();
        typedef FeatStd::Internal::ByteCountToIntegerTypeMapper<sizeof(void*)>::UnsignedType UnsignedType;
        union Accessor {
            struct Memory {
                typedef void(*DisposeFn)(const void*);
                const void* m_data; ///< Pointer to the data buffer.
                DisposeFn m_disposerFunction; ///< Disposer for the data buffer.
            } m_memory;
            struct Asset {
                UnsignedType m_repositoryId : 16;
                UnsignedType m_regionIndex : 16;
                UnsignedType m_offset;
            } m_asset;
            struct Custom {
                UnsignedType m_data[2];
            } m_custom;

            bool IsValid() const;
        } m_accessor;
        UInt32 m_size : 30; ///< Size of the data buffer in bytes.
        UInt32 m_isMutable : 1; ///< Flag specifying if data is mutable or not.
        UInt32 m_isFromAsset : 1; ///< Flag specifying if data is direct addressable (by m_data and m_disposerFunction members) or retrievable in the asset (by m_repositoryId an m_repositoryOffset).
    };

    inline const ResourceDataHandle& ResourceDataHandle::InvalidHandle()
    {
        static ResourceDataHandle invalidHandle = {{{0, 0}}, 0, 0, 0};
        return invalidHandle;
    }

    inline bool ResourceDataHandle::Accessor::IsValid() const
    {
        return ((m_custom.m_data[0] != 0) || (m_custom.m_data[1] != 0));
    }

    /** @} */ // end of CommonBase
} // namespace Candera

#endif  // CANDERA_RESOURCEDATAHANDLE_H
