//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Renderer2D3D_H)
#define CANDERA_Renderer2D3D_H

namespace Candera {

/** @addtogroup CommonBase
*  @{
*/

/**
* @brief   The class Renderer2D3D is responsible of the rendering with 2D- and 3D-cameras.
*          The cameras are rendered in order of their sequence-number which means that 3D-cameras can be rendered between two 2D-cameras and vice versa.
*          If not engine 2D and 3D are enabled it renders only the cameras in the container of the appropriate Renderer.
*/
class Renderer2D3D
{
    public:

        /**
        * Renders all 2D- and 3D-cameras in order of their sequence-number.
        * @return True if rendering of every 2D- and 3D-camera succeeded, false if rendering of any 3D-camera failed.
        */
        static bool RenderAllCameras();
};
/** @} */ // end of CommonBase

} // namespace Candera

#endif // CANDERA_Renderer2D3D_H
