//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Renderer2D3D.h"
#include <Candera/Environment.h>
#ifdef CANDERA_2D_ENABLED
#include <Candera/Engine2D/Core/Renderer2D.h>
#include <Candera/Engine2D/Core/Camera2D.h>
#endif
#ifdef CANDERA_3D_ENABLED
#include <Candera/Engine3D/Core/Renderer.h>
#include <Candera/Engine3D/Core/Camera.h>
#endif

namespace Candera {

    bool Renderer2D3D::RenderAllCameras()
    {
        bool result = true;

#if defined(CANDERA_2D_ENABLED) && defined(CANDERA_3D_ENABLED)
        UInt32 index2D = 0;
        UInt32 index3D = 0;

        // Reset render-statistics.
        Renderer2D::s_statistics.Reset();
        Renderer::s_statistics.Reset();

        // Compare the sequence-number of 2D- and 3D-camera with the last index for each.
        while ((index2D < Renderer2D::GetCameraCount()) && (index3D < Renderer::GetCameraCount())) {

            Camera2D* camera2D = Renderer2D::GetCamera(index2D);
            Camera* camera3D = Renderer::GetCamera(index3D);

            if (camera2D->GetSequenceNumber() <= camera3D->GetSequenceNumber()) {
                if (0 != camera2D->GetRenderTarget()) {
                    Renderer2D::RenderCamera(camera2D);
                }
                index2D++;
            }
            else {
                if (0 != camera3D->GetRenderTarget()) {
                    result = Renderer::RenderCamera(camera3D) && result;
                }
                index3D++;
            }
        }

        // Render remaining cameras.
        while (index2D < Renderer2D::GetCameraCount()) {
            Camera2D* camera2D = Renderer2D::GetCamera(index2D);
            if (0 != camera2D->GetRenderTarget()) {
                Renderer2D::RenderCamera(camera2D);
            }
            index2D++;
        }

        while (index3D < Renderer::GetCameraCount()) {
            Camera* camera3D = Renderer::GetCamera(index3D);
            if (0 != camera3D->GetRenderTarget()) {
                result = Renderer::RenderCamera(camera3D) && result;
            }
            index3D++;
        }
#endif
#if defined(CANDERA_2D_ENABLED) && (!defined(CANDERA_3D_ENABLED))
        UInt32 index2D = 0;

        Renderer2D::s_statistics.Reset();
        // Render 2D-cameras only.
        while (index2D < Renderer2D::GetCameraCount()) {
            Camera2D* camera2D = Renderer2D::GetCamera(index2D);
            if (0 != camera2D->GetRenderTarget()) {
                Renderer2D::RenderCamera(camera2D, false);
            }
            index2D++;
        }
#endif
#if (!defined(CANDERA_2D_ENABLED)) && defined(CANDERA_3D_ENABLED)
        UInt32 index3D = 0;

        Renderer::s_statistics.Reset();
        // Render 3D-cameras only.
        while (index3D < Renderer::GetCameraCount()) {
            Camera* camera3D = Renderer::GetCamera(index3D);
            if (0 != camera3D->GetRenderTarget()) {
                result = Renderer::RenderCamera(camera3D) && result;
            }

            index3D++;
        }
#endif
        return result;
    }

} // namespace Candera
