//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_COMMON_INTERFACE_ADAPTER_H
#define CANDERA_COMMON_INTERFACE_ADAPTER_H

#include <CanderaBehavior/BehaviorBase/Behavior.h>

namespace Candera {
    namespace Internal {
        template <typename T>
        class InterfaceAdapter
        {
        public:
            void Init(T* receiver) {
                m_receiver = receiver;
            }

        protected:
            InterfaceAdapter() :
                m_receiver(0)
            {
            }

            T* GetReceiver() const
            {
                return m_receiver;
            }

        private:
            T* m_receiver;
        };
    } // namespace Internal
} // namespace Candera

#endif
