//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlyphAtlasGlyphCacheAccess.h"

#include <Candera/EngineBase/Common/GlyphAtlas.h>
#include <FeatStd/Util/StaticObject.h>
#include <Candera/TextEngine/Internal/CacheAccessType.h>

namespace Candera
{

GlyphAtlasGlyphCacheAccess& GlyphAtlasGlyphCacheAccess::GetInstance()
{
    FEATSTD_SYNCED_STATIC_OBJECT(GlyphAtlasGlyphCacheAccess, s_instance);
    return s_instance;
}

GlyphAtlasGlyphCacheAccess::GlyphAtlasGlyphCacheAccess()
{
}

GlyphAtlasGlyphCacheAccess::~GlyphAtlasGlyphCacheAccess()
{
    ReleaseCache();
}

UInt8* GlyphAtlasGlyphCacheAccess::Create(const TextRendering::GlyphBitmap& bitmap, UInt8* cacheItem)
{
    return CreateCacheItem<GlyphAtlas>(bitmap, cacheItem);
}

bool GlyphAtlasGlyphCacheAccess::CheckCacheItem(TextRendering::PixelBuffer buffer)
{
    return CheckCacheItemT<GlyphAtlas>(buffer);
}

void GlyphAtlasGlyphCacheAccess::DestroyCacheItem(TextRendering::PixelBuffer buffer)
{
    const GlyphAtlasGlyphCacheItem* glyphAtlasGlyphCacheItem = FeatStd::Internal::PointerToPointer<const GlyphAtlasGlyphCacheItem*>(buffer);
    CANDERA_DELETE(glyphAtlasGlyphCacheItem);
}

Candera::TextRendering::Internal::CacheAccessType::Enum GlyphAtlasGlyphCacheAccess::GetCacheAccessType() const
{
    return TextRendering::Internal::CacheAccessType::GlyphAtlas;
}

}
