//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_GLYPHATLAS_H
#define CANDERA_GLYPHATLAS_H

#include <Candera/Engine2D/Core/BitmapImage2D.h>
#include <Candera/EngineBase/Common/GlyphAtlasCommon.h>

namespace Candera {

/**
 *  Dedicated GlyphAtlas versions exist for 2D and 3D because the GlyphAtlas operates on VRAM.
 *  As a consequence it has to use BitmapImage (which is a DeviceObject2D that is not GL context aware)
 *  for 2D, and BitmapTextureImage for 3D (which is a DeviceObject that is GL context aware).
 */

typedef GlyphAtlasCommon<BitmapImage2D> GlyphAtlas;

template<>
GlyphAtlas& GlyphAtlas::GetInstance();

}

#endif
