//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_EVENT_LISTENER_H)
#define CANDERA_EVENT_LISTENER_H

#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <Candera/System/Rtti/Rtti.h>

namespace Candera {

    /**
     *  Base class for Candera Events.
     */
    class Event {
    public:
        FEATSTD_RTTI_DECLARATION();

        virtual ~Event() {};
    };

    /**
     *  Base class for EventListeners.
     */
    class EventListener {

    public:

        /**
         *  An enum describing the status of the event after it was received by the listener.
         */
        typedef enum {
            EventNotHandled, ///< The event has not been handled by this listener.
            EventHandled,    ///< The event has been handled but it can still be passed to other listeners.
            EventConsumed    ///< The event has been consumed and other listeners shall not be notified of it anymore.
        } EventStatus;

        /**
         *  Receive and handle an Event.
         *  @param event a const reference to an event.
         *  @return the status of the event; this gives information about how the event was handled.
         */
        virtual EventStatus OnEvent(const Event& event) = 0;
    };

}   // namespace Candera

#endif // CANDERA_EVENT_LISTENER_H
