//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_EngineBase_Common_Enums_h)
    #define Candera_EngineBase_Common_Enums_h

namespace Candera {
    /**
        *  Specifies the behavior when cloning a node.
        */
    enum CloneOperation {
        CloneShallow,   ///< Only node properties are copied but attached content like effects are still shared.
        CloneDeep       ///< All node properties and also attached content like effects are cloned.
    };

    /**
        *  Specifies whether the scene graph is traversed (child nodes are processed as well) or not.
        */
    enum TraverseOperation {
        TraverseFlat,   ///< No child nodes are processed.
        TraverseDeep    ///< Child nodes are processed recursively.
    };

}

#endif  // Candera_EngineBase_Common_Enums_h
