//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/EngineBase/Common/CanderaObject.h>

namespace Candera {
    FEATSTD_RTTI_BASECLASS_DEFINITION(CanderaObject)

    CanderaObject::CanderaObject() :
        Base(),
        m_name(0),
        m_id(0)
    {
    }


    CanderaObject::CanderaObject(const Candera::CanderaObject& canderaObject) :
        Base(canderaObject),
        m_name(canderaObject.m_name),                        //lint !e1554 explicitly shallow copy
        m_id(0)
    {
    }

    //lint -e{1540} member under external control
    CanderaObject::~CanderaObject()
    {
    }


    void CanderaObject::SetName(const Char* name)
    {
        m_name = name;
        OnNameChanged();
    }

    CanderaObject& CanderaObject::operator=(const CanderaObject &canderaObject)
    {
        Base::operator = (canderaObject);
        m_name = canderaObject.m_name;                          //lint !e1555 explicitly shallow copy
        m_id = canderaObject.m_id;
        return *this;
    } //lint !e1529 no check for self assignment due to performance reasons

    void CanderaObject::OnNameChanged()
    {
    }

} // namespace Candera
