//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_BITMAPGLYPHCACHEACCESS_H
#define CANDERA_BITMAPGLYPHCACHEACCESS_H

#include <Candera/System/MemoryManagement/CanderaHeap.h>
#include <Candera/TextEngine/GlyphCacheAccess.h>
#include <Candera/TextEngine/Internal/CacheAccessType.h>

namespace Candera
{

FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
class BitmapGlyphCacheAccess : public TextRendering::GlyphCacheAccess
{
public:
    /**
    *  Get the GlyphAtlasGlyphCacheAccess.
    *  @return  A reference to the GlyphAtlasGlyphCacheAccess instance.
    */
    static BitmapGlyphCacheAccess& GetInstance();

    // overrides TextRendering::GlyphCacheAccess::Create
    virtual UInt8* Create(const TextRendering::GlyphBitmap& bitmap, UInt8* cacheItem) override;

    // overrides TextRendering::GlyphCacheAccess::CheckCacheItem
    virtual bool CheckCacheItem(TextRendering::PixelBuffer buffer) override;

    // overrides TextRendering::GlyphCacheAccess::DestroyCacheItem
    virtual void DestroyCacheItem(TextRendering::PixelBuffer buffer) override;

    virtual TextRendering::Internal::CacheAccessType::Enum GetCacheAccessType() const;

private:

    friend struct FeatStd::MemoryManagement::Internal::Destructor <BitmapGlyphCacheAccess>;
    virtual ~BitmapGlyphCacheAccess() override;

    FEATSTD_MAKE_CLASS_STATIC(BitmapGlyphCacheAccess);
    FEATSTD_MAKE_CLASS_UNCOPYABLE(BitmapGlyphCacheAccess);
};
FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

}

#endif
