//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_ENGINEBASE_ABSTRACT_NODE_POINTER_TRAVERSER_H
#define CANDERA_ENGINEBASE_ABSTRACT_NODE_POINTER_TRAVERSER_H

#include <Candera/EngineBase/Common/AbstractNodePointer.h>

namespace Candera {
namespace Internal {
    class AbstractNodePointerTraverser
    {
    public:
        enum TraverserAction
        {
            ProceedTraversing,              ///< Traversing continues with the next child (if the current node has any) or sibling.
            StopTraversingForDescendants,   ///< Traversing will stop for all child nodes and will continue with the next sibling.
            StopTraversing                  ///< Traversing will stop here.
        };

        void Traverse(const AbstractNodePointer& root);

    protected:
        AbstractNodePointerTraverser() { }
        AbstractNodePointerTraverser(const AbstractNodePointerTraverser&) { }
        AbstractNodePointerTraverser& operator=(const AbstractNodePointerTraverser&) { return *this; }

        virtual TraverserAction ProcessNode(const AbstractNodePointer& /*node*/)
        {
            return ProceedTraversing;
        }
    };
} // namespace Internal
} // namespace Candera

#endif //CANDERA_ENGINEBASE_ABSTRACT_NODE_POINTER_H
