//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "AbstractNodePointerTraverser.h"

namespace Candera {
namespace Internal {

void AbstractNodePointerTraverser::Traverse(const AbstractNodePointer& root)
{
    AbstractNodePointer currentNode = root;
    bool allChildrenOfRootProcessed = !currentNode.IsValid();
    AbstractNodePointer nextChild = currentNode.GetFirstChild();
    TraverserAction action = ProceedTraversing;

    while ((!allChildrenOfRootProcessed) && (action != StopTraversing)) {
        action = ProceedTraversing;
        // Process the current node before its children.
        if (nextChild == currentNode.GetFirstChild()) {
            // Const cast: see function comment.
            action = ProcessNode(currentNode);
        }

        // Process the children (if traversal has not been stopped by ProcessNode()'s return at the parent).
        if (action != StopTraversing) {
            const bool allChildrenAlreadyProcessed = (!nextChild.IsValid());

            if ((allChildrenAlreadyProcessed) || (action == StopTraversingForDescendants)) {
                // Up to parent, with next of parent's children (== currentNode's next sibling).
                if (currentNode == root) {
                    allChildrenOfRootProcessed = true;
                }
                else {
                    nextChild = currentNode.GetNextSibling();
                }
                currentNode = currentNode.GetParent();
            }
            else {
                // down to child
                currentNode = nextChild;
                nextChild = currentNode.GetFirstChild();
            }
        }
    }
}

} // namespace Internal
} // namespace Candera
