//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "StepInterpolationStrategy.h"
#include <Candera/EngineBase/Animation/KeyframeSequence.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaPlatform/OS/MemoryPlatform.h>

namespace Candera { namespace Animation {
    using namespace Diagnostics;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaAnimation);

    FEATSTD_RTTI_DEFINITION(StepInterpolationStrategy, InterpolationStrategy)

    StepInterpolationStrategy::SharedPointer StepInterpolationStrategy::Create()
    {
        return StepInterpolationStrategy::SharedPointer(FEATSTD_NEW(StepInterpolationStrategy)());
    }

    void StepInterpolationStrategy::Interpolate(const KeyframeSequence* keyframeSequence, SequenceTimeType sequenceTime, Float* resultValue) const
    {
        // caller should guarantee this
        if (keyframeSequence->GetKeyframeCount() < 2) {
            FEATSTD_LOG_ERROR("Interpolation failed, too few keyframes.");
            for (Int32 i = 0; i < keyframeSequence->GetNumberOfComponents(); ++i) {
                resultValue[i] = 0.0F;
            }
            return;
        }

        // special case at/beyond last key frame
        const KeyframeSequence::Keyframe lastKeyframe = keyframeSequence->GetKeyframe(static_cast<Int>(keyframeSequence->GetKeyframeCount() - 1));
        if (sequenceTime >= lastKeyframe.m_sequencetimeMs) {
            MemoryPlatform::Copy(resultValue, lastKeyframe.m_valuesBegin, static_cast<SizeType>(keyframeSequence->GetNumberOfComponents()) * sizeof(Float));
            return;
        }

        Int32 indexLeft = 0;
        Int32 indexRight = 1;
        const_cast<Animation::KeyframeSequence*>(keyframeSequence)->Find2FramesAroundSequenceTime(sequenceTime, indexLeft, indexRight);
        const KeyframeSequence::Keyframe leftKeyframe = keyframeSequence->GetKeyframe(indexLeft);
        MemoryPlatform::Copy(resultValue, leftKeyframe.m_valuesBegin, static_cast<SizeType>(keyframeSequence->GetNumberOfComponents()) * sizeof(Float));
    }

    } // namespace Animation
} // namespace Candera
