//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SplineInterpolationStrategy_H)
#define CANDERA_SplineInterpolationStrategy_H

#include <Candera/EngineBase/Animation/InterpolationStrategy.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

    /**
     * @brief InterpolationStrategy implementation.
     *
     * This interpolation strategy produces a spline transition between keyframe values.
     * Each interpolated value is calculated using a cubic polynomial function based on four
     * keyframes around the given sequence time. The spline interpolation assures smooth
     * value transitions around keyframe sequence times.
     */
    class SplineInterpolationStrategy: public InterpolationStrategy {

        FEATSTD_TYPEDEF_BASE(InterpolationStrategy);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(SplineInterpolationStrategy);

            FEATSTD_RTTI_DECLARATION();

            /**
             *  Creates a StepInterpolationStrategy object.
             *  @return Pointer to the created StepInterpolationStrategy object.
             */
            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Destructs an StepInterpolationStrategy object.
             */
            virtual ~SplineInterpolationStrategy() override {}

            /**
             *  Calculate the interpolated value of a KeyframeSequence at a given sequence time.
             *  @param keyframeSequence   The sequence of keyframes the interpolation strategy should be applied on.
             *  @param sequenceTime       The time at which the interpolated value should be calculated.
             *  @param resultValue [out]  The resulted interpolated value.
             */
            virtual void Interpolate(
                const KeyframeSequence* keyframeSequence,
                SequenceTimeType sequenceTime,
                Float* resultValue) const override;

        protected:
            SplineInterpolationStrategy() {}

    };

 /** @} */ // end of AnimationBase

    } // namespace Animation
} // namespace Candera

#endif
