//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_ANIMATION_SCRIPTPARAMETERANIMATIONPROPERTYSETTER_H
#define CANDERA_ANIMATION_SCRIPTPARAMETERANIMATIONPROPERTYSETTER_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <CanderaScripting/ScriptSystem.h>


namespace Candera {

namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

/**
 * @brief Animates a public script parameter of type ScriptComponent::Integer (Int) or ScriptComponent::Number (Double).
 */
class ScriptParameterAnimationPropertySetter : public AnimationPropertySetter
{
public:
    FEATSTD_TYPEDEF_SHARED_POINTER(ScriptParameterAnimationPropertySetter);
    FEATSTD_RTTI_DECLARATION();
    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    /**
     *  Set the value.
     *  @param value  The value that is set.
     */
    virtual void Set(const Float* value) override;

    /**
     *  Set the script component of the script parameter to be animated.
     *  @param scriptComponent  The handle of the script component of the script parameter to be animated.
     */
    void SetScriptComponent(Scripting::ScriptSystem::Handle scriptComponent) { m_scriptComponent = scriptComponent; }

    /**
     *  Set the name of the script parameter to be animated.
     *  @param parameterName  The name of the script parameter to be animated.
     *  @param isOwner        True, if this property setter owns the parameterName string. False, otherwise.
     */
    void SetScriptParameterName(const Char* parameterName, bool isOwner = false);

private:
    FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

    ScriptParameterAnimationPropertySetter();
    virtual ~ScriptParameterAnimationPropertySetter();

    Scripting::ScriptSystem::Handle m_scriptComponent;
    const Char* m_parameterName;
    bool m_isParameterNameOwner;
};

/** @} */ // end of AnimationBase

}

}
#endif
