//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ScriptParameterAnimationPropertySetter.h"

#include <Candera/System/Diagnostics/Log.h>
#include <Candera/System/EntityComponentSystem/EntitySystem.h>
#include <Candera/System/EntityComponentSystem/ComponentPointer.h>

namespace Candera
{

FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAnimation);

namespace Animation
{

FEATSTD_RTTI_DEFINITION(ScriptParameterAnimationPropertySetter, AnimationPropertySetter)

ScriptParameterAnimationPropertySetter::ScriptParameterAnimationPropertySetter()
    :
    m_parameterName(0),
    m_isParameterNameOwner(false)
{
}

ScriptParameterAnimationPropertySetter::~ScriptParameterAnimationPropertySetter()
{
    if (m_isParameterNameOwner) {
        CANDERA_DELETE_ARRAY(m_parameterName);
        m_parameterName = 0;
    }
}

ScriptParameterAnimationPropertySetter::SharedPointer ScriptParameterAnimationPropertySetter::Create()
{
    return ScriptParameterAnimationPropertySetter::SharedPointer(CANDERA_NEW(ScriptParameterAnimationPropertySetter));
}

void ScriptParameterAnimationPropertySetter::Set(const Float* value)
{
    using namespace Scripting;
    using namespace EntityComponentSystem;

    if (0 != m_parameterName) {
        if (!m_scriptComponent.IsNullHandle()) {
            ScriptSystem* scriptSystem = EntitySystem::Get<ScriptSystem>();
            if (0 != scriptSystem) {
                if (!scriptSystem->SetComponentLiveParameterNumber(m_scriptComponent, m_parameterName, static_cast<Double>(*value))) {
                    ScriptSystem::Pointer scriptComponentPtr(scriptSystem, m_scriptComponent);
                    if (scriptComponentPtr.IsNull()) {
                        FEATSTD_LOG_ERROR("Invalid script component handle when trying to set script parameter '%s'", m_parameterName);
                    }
                    else {
                        CanderaObject* object = scriptComponentPtr->GetEntity();
                        const Char* objectName = "(null)";
                        if ((0 != object) && (0 != object->GetName())){
                            objectName = object->GetName();
                        }
                        FEATSTD_UNUSED(objectName); // if logging is disabled, variable/parameter is not used
                        FEATSTD_LOG_ERROR("Failed to set script parameter '%s' at object '%s'", m_parameterName, objectName);
                    }
                }
            }
        }
    }
}

void ScriptParameterAnimationPropertySetter::SetScriptParameterName(const Char* parameterName, bool isOwner)
{
    if (m_isParameterNameOwner && (parameterName != m_parameterName)) {
        CANDERA_DELETE_ARRAY(m_parameterName);
    }

    m_parameterName = parameterName;
    m_isParameterNameOwner = isOwner;
}

}

}
