//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RelativePropertySetter_H)
#define CANDERA_RelativePropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>

namespace Candera {
    namespace Animation {
/** @addtogroup AnimationBase
 *  @{
 */

        /**
         * @brief A relative AnimationPropertySetter.
         *
         * This is a base class. Its purpose is to introduce a virtual function for initializing
         * the base value for the relative animation with the current property value.
         * Each consecutive Set call will use the received value as an offset to the base one.
         */
        class RelativePropertySetter : public AnimationPropertySetter {
            FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

        public:
            FEATSTD_RTTI_DECLARATION();

            /**
             *  Initialize base value for the relative animation.
             */
            virtual void Initialize() = 0;
        };

 /** @} */ // end of AnimationBase
    }
}
#endif
