//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PowerEaseFunction.h"
#include <Candera/System/Mathematics/Math.h>
#include <Candera/System/Diagnostics/Log.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>

namespace Candera { namespace Animation {
    using namespace Diagnostics;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaAnimation);

    FEATSTD_RTTI_BASECLASS_DEFINITION(PowerEaseFunction)

    PowerEaseFunction::PowerEaseFunction() :
        Base(),
        m_power(1U)
    {
    }

    PowerEaseFunction::~PowerEaseFunction()
    {
    }

    PowerEaseFunction::SharedPointer PowerEaseFunction::Create()
    {
        return PowerEaseFunction::SharedPointer(CANDERA_NEW(PowerEaseFunction));
    }

    Float PowerEaseFunction::Resolve(Float inValue) const
    {
        return Math::Power(inValue, Float(m_power));
    }

    void PowerEaseFunction::SetPower(UInt8 power)
    {
        if (power > 0) {
            m_power = power;
        }
        else {
            FEATSTD_LOG_INFO("Power less than 1. Value ignored.");
        }
    }

    UInt8 PowerEaseFunction::GetPower() const
    {
        return m_power;
    }

    } // namespace Animation
} // namespace Candera
