//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ElasticEaseFunction.h"
#include <Candera/System/Mathematics/Math.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(ElasticEaseFunction, ExponentialEaseFunction)

    ElasticEaseFunction::ElasticEaseFunction() :
        Base(),
        m_oscillationCount(0U)
    {
    }

    ElasticEaseFunction::~ElasticEaseFunction()
    {
    }

    ElasticEaseFunction::SharedPointer ElasticEaseFunction::Create()
    {
        return ElasticEaseFunction::SharedPointer(CANDERA_NEW(ElasticEaseFunction));
    }

    Float ElasticEaseFunction::Resolve(Float inValue) const
    {
        return ExponentialEaseFunction::Resolve(inValue) * Math::Sine(inValue * static_cast<Float>((4 * m_oscillationCount) + 1) * Math::PiHalf());
    }

    void ElasticEaseFunction::SetOscillationCount(UInt8 oscillationCount)
    {
        m_oscillationCount = oscillationCount;
    }

    Candera::UInt8 ElasticEaseFunction::GetOscillationCount() const
    {
        return m_oscillationCount;
    }

    } // namespace Animation
} // namespace Candera
