//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BackFunction_H)
#define CANDERA_BackFunction_H

#include <Candera/EngineBase/Animation/AbstractEasingFunction.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

    /**
     *  @brief BackEaseFunction implements an animation ease function that starts from 0.0F,
     *   retracts to a negative minimum and then grows back until it reaches value 1.0F.
     */
    class BackEaseFunction : public AbstractEasingFunction {
        FEATSTD_TYPEDEF_BASE(AbstractEasingFunction);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(BackEaseFunction);
            
            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
            /**
            *  Constructor
            */
            BackEaseFunction();
            
            /**
             *  Destructor
             */
            virtual ~BackEaseFunction() override;

            /**
             *  Function solve method.
             *  @param inValue  Function inValue argument.
             *  @return computed output of function for given argument.
             */
            virtual Float Resolve(Float inValue) const override;

            /**
             * Set retraction amplitude.
             * The retraction amplitude can be any positive float value, 0.0F meaning no retraction.
             * @param amplitude Retraction amplitude.
             */
            void SetAmplitude(Float amplitude);

            /**
             * Get Amplitude.
             * @return retraction amplitude.
             */
            Float GetAmplitude() const;

            FEATSTD_RTTI_DECLARATION();

        private:
            Float m_amplitude;
    };


 /** @} */ // end of AnimationBase
    } // namespace Animation
} // namespace Candera

#endif
