//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BackEaseFunction.h"
#include <Candera/System/Diagnostics/Log.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>

namespace Candera { namespace Animation {
    using namespace Diagnostics;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaAnimation);

    FEATSTD_RTTI_BASECLASS_DEFINITION(BackEaseFunction)

    BackEaseFunction::BackEaseFunction() :
        Base(),
        m_amplitude(1.0F)
    {
    }

    BackEaseFunction::~BackEaseFunction()
    {
    }

    BackEaseFunction::SharedPointer BackEaseFunction::Create()
    {
        return BackEaseFunction::SharedPointer(CANDERA_NEW(BackEaseFunction));
    }

    void BackEaseFunction::SetAmplitude(Float amplitude)
    {
        if (amplitude >= 0.0F) {
            m_amplitude = amplitude;
        }
        else {
            FEATSTD_LOG_INFO("Negative amplitude. Value ignored.");
        }
    }

    Float BackEaseFunction::GetAmplitude() const
    {
        return m_amplitude;
    }

    Float BackEaseFunction::Resolve(Float inValue) const
    {
        const Float inValue2 = inValue * inValue;
        return ((m_amplitude + 1.0F) * inValue2 * inValue) - (m_amplitude * inValue2);
    }

    } // namespace Animation
} // namespace Candera
