//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_AnimationKeyframeSequence_H)
#define CANDERA_AnimationKeyframeSequence_H

#include <Candera/EngineBase/Animation/KeyframeSequence.h>
#include <Candera/EngineBase/Animation/InterpolationStrategy.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

/**
 * @brief A KeyframeSequence that provides interpolation between keyframes.
 */
CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1790, "virtual dtor explicitly defined non virual")
class AnimationKeyframeSequence : public KeyframeSequence
{
    FEATSTD_TYPEDEF_BASE(KeyframeSequence);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(AnimationKeyframeSequence);

        /**
         *  Creates a AnimationKeyframeSequence object.
         *  @return MemoryManagement::SharedPointer to the created AnimationKeyframeSequence object.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         *  Destructor
         */
        ~AnimationKeyframeSequence() override;// non-virtual; not intended for subclassing

        /**
         *  Interpolate
         *  @param sequenceTimeMs   The sequence time in milliseconds.
         *  @param resultValues     Pointer to the result value.
         */
        void Interpolate(SequenceTimeType sequenceTimeMs, Float* resultValues) const;

        /**
         *  Sets the interpolation strategy.
         *  @param interpolationStrategy    The interpolation strategy that is set.
         */
        void SetInterpolationStrategy(const InterpolationStrategy::SharedPointer& interpolationStrategy);

        /**
         *  Retrieves the interpolation strategy.
         *  @return The interpolation strategy.
         */
        InterpolationStrategy::SharedPointer GetInterpolationStrategy() const {
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1763, Candera::Animation::AnimationKeyframeSequence::GetInterpolationStrategy, CANDERA_LINT_REASON_NONCONST)
            return m_interpolationStrategy;
        }

        /**
         *  Enables or disables period.
         *  @param periodic Boolean that is set.
         */
        void SetPeriodic(bool periodic) { m_isPeriodic = periodic; }

        /**
         *  Retrieves whether periodic is enabled or not.
         *  @return True, if periodic is enabled, false otherwise.
         */
        bool IsPeriodic() const { return m_isPeriodic; }

    private:
        bool m_isPeriodic;
        InterpolationStrategy::SharedPointer m_interpolationStrategy;

        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::AnimationKeyframeSequence::AnimationKeyframeSequence, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
        AnimationKeyframeSequence();
        AnimationKeyframeSequence(const AnimationKeyframeSequence& other);//lint !e1704 forbidden until plausible reason provided
        AnimationKeyframeSequence& operator=(const AnimationKeyframeSequence& other);
};

 /** @} */ // end of AnimationBase
    
    } // namespace Animation
} // namespace Candera
#endif
