//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_AbstractEasingFunction_H)
#define CANDERA_AbstractEasingFunction_H

#include <Candera/Environment.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <FeatStd/Util/Rtti.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

/**
 *  @brief AbstractEasingFunction provides an interface for solving mathematical functions.
 *
 *  Animation ease functions implement this interface with following considerations:
 *  - function must be solvable for any float value between [0..1].
 *  - function should return value 0.0F for an 0.0F argument.
 *  - function should return value 1.0F for an 1.0F argument.
 */
class AbstractEasingFunction {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(AbstractEasingFunction);

        /**
         *  Destructor
         */
        virtual ~AbstractEasingFunction() {};

        /**
         *  Function solve method.
         *
         *  @param inValue  Function argument.
         *  @return computed output of function for given argument.
         */
        virtual Float Resolve(Float inValue) const = 0;

        FEATSTD_RTTI_DECLARATION();
        FEATSTD_SHARED_POINTER_DECLARATION();

    protected:
        AbstractEasingFunction() {};
};

 /** @} */ // end of AnimationBase
    }   // namespace Animation

} // namespace Candera

#endif
