//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LAYOUT_3D_CANVASTEXTLAYOUTER_H)
#define CANDERA_LAYOUT_3D_CANVASTEXTLAYOUTER_H

#include <Candera/EngineBase/Layout/Layouter.h>
#include <Candera/Engine3D/Canvas/CanvasText.h>
namespace Candera {
    class CanvasTextLayouter : public Layouter {
    public:
        virtual ~CanvasTextLayouter() {}


        // overrides Layouter::OnMeasure
        virtual Vector2 OnMeasure(const AbstractNodePointer& node, const Vector2& clientArea);

        // overrides Layouter::OnArrange
        virtual void OnArrange(const AbstractNodePointer& node, const Candera::Rectangle& clientArea);


        // overrides Layouter::Clone
        virtual Layouter* Clone() const override;
        // overrides Layouter::Dispose
        virtual void Dispose() override;
        /**
        * @return The default TextNode2DLayouter instance.
        */
        static CanvasTextLayouter& GetDefault();

    protected:
        CanvasTextLayouter() {}
        CanvasText::HorizontalTextAlignment::Enum GetLanguageSensitiveTextAlignment(CanvasText& textNode) const;
    };


}

#endif  // CANDERA_LAYOUT_3D_CANVASTEXTLAYOUTER_H
