//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ENGINE3D_H)
#define CANDERA_ENGINE3D_H

// AnimationPropertySetters
#include <Candera/Engine3D/AnimationPropertySetters/AlphaNodePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/BoolUniformPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/CameraFovPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/CameraScissorRectanglePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/CameraViewportPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/CanvasVertexRectanglePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/ColorLightPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/ColorPropertySetterUtil.h>
#include <Candera/Engine3D/AnimationPropertySetters/FloatUniformPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/GenericLodCriterionValuePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/IntUniformPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/LightPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/MaterialColorPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/MaterialPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/MaterialSpecularPowerPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/MorphWeightPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/NodeAppearancePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/NodeBlendColorPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/NodePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/NodeRelativePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/RenderingEnabledNodePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/RotateNodePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/RotateNodeRelativePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/ScaleNodePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/ScaleNodeRelativePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/TranslateNodePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/TranslateNodeRelativePropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/UniformPropertySetter.h>
#include <Candera/Engine3D/AnimationPropertySetters/Vector3PropertySetterUtil.h>

//Cloning
#include <Candera/Engine3D/Cloning/DeepAppearanceCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepCameraCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepCompositeGroupCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepLodNodeCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepNodeCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepReflectionCameraCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepSceneCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepStereoCameraCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepTreeCloner.h>
#include <Candera/Engine3D/Cloning/NodeCloneStrategy.h>
#include <Candera/Engine3D/Cloning/TreeCloner.h>
#include <Candera/Engine3D/Cloning/TreeMatch.h>

// Core
#include <Candera/Engine3D/Core/Appearance.h>
#include <Candera/Engine3D/Core/BenchmarkCameraRenderStrategy.h>
#include <Candera/Engine3D/Core/Billboard.h>
#include <Candera/Engine3D/Core/BitmapTextureImage.h>
#include <Candera/Engine3D/Core/BlendLodRenderStrategy.h>
#include <Candera/Engine3D/Core/BreakNodeCameraRenderStrategy.h>
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/Engine3D/Core/CameraListener.h>
#include <Candera/Engine3D/Core/CameraRenderStrategy.h>
#include <Candera/Engine3D/Core/ClearMode.h>
#include <Candera/Engine3D/Core/CompositeGroup.h>
#include <Candera/Engine3D/Core/CubeMapTextureImage.h>
#include <Candera/Engine3D/Core/DeviceObject.h>
#include <Candera/Engine3D/Core/DeviceObjectListener.h>
#include <Candera/Engine3D/Core/DiscreteLodRenderStrategy.h>
#include <Candera/Engine3D/Core/DistanceToCameraLodCriterion.h>
#include <Candera/Engine3D/Core/Frustum.h>
#include <Candera/Engine3D/Core/GenericProjection.h>
#include <Candera/Engine3D/Core/GenericValueLodCriterion.h>
#include <Candera/Engine3D/Core/GlyphAtlas3D.h>
#include <Candera/Engine3D/Core/GlyphAtlas3DGlyphCacheAccess.h>
#include <Candera/Engine3D/Core/GlyphAtlasTextNodeRenderer.h>
#include <Candera/Engine3D/Core/Group.h>
#include <Candera/Engine3D/Core/Light.h>
#include <Candera/Engine3D/Core/LineList.h>
#include <Candera/Engine3D/Core/LodCriterion.h>
#include <Candera/Engine3D/Core/LodNode.h>
#include <Candera/Engine3D/Core/LodRenderStrategy.h>
#include <Candera/Engine3D/Core/Material.h>
#include <Candera/Engine3D/Core/Mesh.h>
#include <Candera/Engine3D/Core/MorphingMesh.h>
#include <Candera/Engine3D/Core/MultiPassAppearance.h>
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/NodeListener.h>
#include <Candera/Engine3D/Core/NodeRenderSequence.h>
#include <Candera/Engine3D/Core/OcclusionCullingCameraRenderStrategy.h>
#include <Candera/Engine3D/Core/OrthographicProjection.h>
#include <Candera/Engine3D/Core/PerspectiveProjection.h>
#include <Candera/Engine3D/Core/PickFrustum.h>
#include <Candera/Engine3D/Core/PixelBuffer.h>
#include <Candera/Engine3D/Core/PlanarShadow.h>
#include <Candera/Engine3D/Core/PointSprite.h>
#include <Candera/Engine3D/Core/Projection.h>
#include <Candera/Engine3D/Core/ProjectionListener.h>
#include <Candera/Engine3D/Core/ProxyTextureImage.h>
#include <Candera/Engine3D/Core/QueryProperty.h>
#include <Candera/Engine3D/Core/ReflectionCamera.h>
#include <Candera/Engine3D/Core/Renderable.h>
#include <Candera/Engine3D/Core/RenderBuffer.h>
#include <Candera/Engine3D/Core/Renderer.h>
#include <Candera/Engine3D/Core/RendererListener.h>
#include <Candera/Engine3D/Core/RendererStatisticsOverlay.h>
#include <Candera/Engine3D/Core/RenderMode.h>
#include <Candera/Engine3D/Core/Scene.h>
#include <Candera/Engine3D/Core/SceneListener.h>
#include <Candera/Engine3D/Core/Shader.h>
#include <Candera/Engine3D/Core/ShaderParamNames.h>
#include <Candera/Engine3D/Core/SkyBox.h>
#include <Candera/Engine3D/Core/StereoCamera.h>
#include <Candera/Engine3D/Core/StereoProjection.h>
#include <Candera/Engine3D/Core/SynchronizationFence.h>
#include <Candera/Engine3D/Core/Texture.h>
#include <Candera/Engine3D/Core/TextureImage.h>
#include <Candera/Engine3D/Core/Transformable.h>
#include <Candera/Engine3D/Core/TreeTraverser.h>
#include <Candera/Engine3D/Core/UniformBuffer.h>
#include <Candera/Engine3D/Core/VertexBuffer.h>
#include <Candera/Engine3D/Core/VertexGeometry.h>
#include <Candera/Engine3D/Core/VertexGeometryBuilder.h>
#include <Candera/Engine3D/Core/ViewingFrustum.h>

// Mathematics
#include <Candera/Engine3D/Mathematics/Math3D.h>

//RenderOrder
#include <Candera/Engine3D/RenderOrder/AbstractRenderOrder.h>
#include <Candera/Engine3D/RenderOrder/BatchOrderCriterion.h>
#include <Candera/Engine3D/RenderOrder/DistanceToCameraOrderCriterion.h>
#include <Candera/Engine3D/RenderOrder/OrderCriterion.h>
#include <Candera/Engine3D/RenderOrder/OrderCriterionValue.h>
#include <Candera/Engine3D/RenderOrder/RankOrderCriterion.h>
#include <Candera/Engine3D/RenderOrder/RenderOrder.h>
#include <Candera/Engine3D/RenderOrder/RenderOrderBin.h>
#include <Candera/Engine3D/RenderOrder/RenderStateOrderCriterion.h>

//ShaderParamSetters
#include <Candera/Engine3D/ShaderParamSetters/AbstractShaderParamSetter.h>
#include <Candera/Engine3D/ShaderParamSetters/ShaderParamSetter.h>
#include <Candera/Engine3D/ShaderParamSetters/GenericShaderParamSetter.h>

//Canvas
#include <Candera/Engine3D/Canvas/CanvasRenderable.h>
#include <Candera/Engine3D/Canvas/CanvasSprite.h>

#endif    // CANDERA_ENGINE3D_H

