//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_VIEWINGFRUSTUM_H)
#define CANDERA_VIEWINGFRUSTUM_H

#include <Candera/Engine3D/Core/Frustum.h>

namespace Candera {

/**  @addtogroup Core3D
 *   @{
 */
 
class Mesh;
class Camera;

/**
*  @brief The ViewingFrustum class calculates the frustum planes for a given camera.
*         It provides methods to determine whether a point, sphere or mesh is within 
*         the viewing frustum or not.
*/

class ViewingFrustum : public Frustum {

    public:        

        /**
         *  Constructor
         */
        ViewingFrustum();

        /**
         *  Destructor
         */
        ~ViewingFrustum(); //non-virtual

        /**   
         *  Sets the camera for the ViewingFrustum.
         *  @param camera Camera to be set for the ViewingFrustum
         */
        void SetCamera(Camera* camera) { m_camera = camera; }

        /**   
         *  Calculates the frustum planes.
         *  Has to be called each time the view of the camera changes.
         */
        virtual void Recalculate() override;
        
    private:

        Camera* m_camera;    
};
 
/**  @} */ // end of Core3D
 
} //namespace Candera

#endif // CANDERA_VIEWINGFRUSTUM_H
