//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ViewingFrustum.h"
#include <Candera/Engine3D/Core/Mesh.h>
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/System/Mathematics/Vector3.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera {
    using namespace Diagnostics;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

ViewingFrustum::ViewingFrustum() :
    m_camera(0)
{
}

ViewingFrustum::~ViewingFrustum()
{
    m_camera = 0;
}

void ViewingFrustum::Recalculate()
{
  if (m_camera == 0) {
      FEATSTD_LOG_ERROR("Viewing frustum recalculate failed, m_camera == 0.");
      return;
  }

  Matrix4 vpMatrix = m_camera->GetViewProjectionMatrix();

  m_planes[LeftPlane].SetDirection(Vector3(vpMatrix.Get(0,3) + vpMatrix.Get(0,0),
                                           vpMatrix.Get(1,3) + vpMatrix.Get(1,0),
                                           vpMatrix.Get(2,3) + vpMatrix.Get(2,0)));
  m_planes[LeftPlane].SetDistance(vpMatrix.Get(3,3) + vpMatrix.Get(3,0));

  m_planes[RightPlane].SetDirection(Vector3(vpMatrix.Get(0,3) - vpMatrix.Get(0,0),
                                            vpMatrix.Get(1,3) - vpMatrix.Get(1,0),
                                            vpMatrix.Get(2,3) - vpMatrix.Get(2,0)));

  m_planes[RightPlane].SetDistance(vpMatrix.Get(3,3) - vpMatrix.Get(3,0));

  m_planes[TopPlane].SetDirection(Vector3(vpMatrix.Get(0,3) - vpMatrix.Get(0,1),
                                          vpMatrix.Get(1,3) - vpMatrix.Get(1,1),
                                          vpMatrix.Get(2,3) - vpMatrix.Get(2,1)));

  m_planes[TopPlane].SetDistance(vpMatrix.Get(3,3) - vpMatrix.Get(3,1));

  m_planes[BottomPlane].SetDirection(Vector3(vpMatrix.Get(0,3) + vpMatrix.Get(0,1),
                                             vpMatrix.Get(1,3) + vpMatrix.Get(1,1),
                                             vpMatrix.Get(2,3) + vpMatrix.Get(2,1)));
  m_planes[BottomPlane].SetDistance(vpMatrix.Get(3,3) + vpMatrix.Get(3,1));

  m_planes[FarPlane].SetDirection(Vector3(vpMatrix.Get(0,3) - vpMatrix.Get(0,2),
                                           vpMatrix.Get(1,3) - vpMatrix.Get(1,2),
                                           vpMatrix.Get(2,3) - vpMatrix.Get(2,2)));
  m_planes[FarPlane].SetDistance(vpMatrix.Get(3,3) - vpMatrix.Get(3,2));

  m_planes[NearPlane].SetDirection(Vector3(vpMatrix.Get(0,3) + vpMatrix.Get(0,2),
                                           vpMatrix.Get(1,3) + vpMatrix.Get(1,2),
                                           vpMatrix.Get(2,3) + vpMatrix.Get(2,2)));
  m_planes[NearPlane].SetDistance(vpMatrix.Get(3,3) + vpMatrix.Get(3,2));

  for (UInt8 i=0; i<NumberOfPlanes; i++) {
      m_planes[i].SetDistance(m_planes[i].GetDistance() / m_planes[i].GetDirection().GetLength());
      m_planes[i].Normalize();
  }
}//RecalculateFrustum
} // namespace Candera

