//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "UniformNode.h"

#include <Candera/Engine3D/Core/Shader.h>

namespace Candera {
namespace Internal {

    UniformNode::UniformNode(const Char* name, Shader::UniformType type, void* data, Int32 count, bool isDataVolatile)
    :
    m_count(count),
    m_type(type),
    m_name(name),
    m_data(data),
    m_size(Shader::GetSize(type) * static_cast<SizeType>(count)),
    m_isOwner(isDataVolatile)
{
    if (m_isOwner) {
        m_name = CANDERA_NEW_ARRAY(Char, StringPlatform::Length(name)+1);
        if (0 == m_name) {
            return;
        }

        StringPlatform::Copy(const_cast<Char*>(m_name), name);
        m_data = CANDERA_NEW_ARRAY(UInt8, m_size);
        if (0 == m_data) {
            CANDERA_DELETE_ARRAY(m_name);
            m_name = 0;
            return;
        }

        MemoryPlatform::Copy(m_data, data, m_size);
    }
}

UniformNode::~UniformNode()
{
    if (m_isOwner) {
        CANDERA_DELETE_ARRAY(m_name);
        CANDERA_DELETE_ARRAY(m_data);
    }

    m_name = 0;
    m_data = 0;
}

void UniformNode::SetData(void* data, bool isVolatile)
{
    FEATSTD_DEBUG_ASSERT(data != 0);
    if ((!m_isOwner) && (!isVolatile)) {
        m_data = data;
    }
    else {
        FEATSTD_DEBUG_ASSERT(m_data != 0);
        MemoryPlatform::Copy(m_data, data, m_size);
    }
}

}
}
