//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "SynchronizationFence.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice.h>

namespace Candera {

    using namespace Diagnostics;
    using namespace MemoryManagement;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

    const UInt64 SynchronizationFence::c_IgnoreTimeout = RenderDevice::c_IgnoreWaitTimeOut;

    SynchronizationFence::SynchronizationFence()
        :m_fenceHandle(0)
    {
    }

    SynchronizationFence::~SynchronizationFence()
    {
        RenderDevice::DestroySynchronizationFence(m_fenceHandle);
        m_fenceHandle = 0;
    }

    SharedPointer<SynchronizationFence> SynchronizationFence::Create()
    {
        SynchronizationFence::SharedPointer fence(FEATSTD_NEW(SynchronizationFence));
        if (!fence.PointsToNull()) {
            if (!RenderDevice::CreateSynchronizationFence(fence->m_fenceHandle)) {
                fence.Release();
                FEATSTD_LOG_ERROR("Failed to create SynchronizationFence object!");
            }
        }

        return fence;
    }

    bool SynchronizationFence::IsProcessed()
    {
        return RenderDevice::IsSynchronizationFenceSignaled(m_fenceHandle);
    }

    SynchronizationFence::WaitResult SynchronizationFence::ClientWait(UInt64 timeout, bool flushBufferedCommands)
    {
        return RenderDevice::ClientWaitSynchronizationFence(m_fenceHandle, timeout, flushBufferedCommands);
    }

}
