//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_SceneListener_h
#define Candera_SceneListener_h

#include <Candera/Environment.h>

namespace Candera {

/** @addtogroup Core3D
 *  @{
 */

/**
* @brief The abstract class SceneListener defines an interface utilized by class Scene to notify listeners on certain Scene actions.
*/
class SceneListener
{
    public:
        /**
            * Constructs a SceneListener object.                         
            */
        SceneListener() {}

        /**
            * Destructs a SceneListener object.                         
            */
        virtual ~SceneListener() {}

        /**
            * OnSceneActivated is called after scene has been activated by renderer. 
            * Thus, the scene's camera and lights are already set active for the next render pass pending.   
            * Hint: This function is invoked before CameraListener::OnPreRender.
            * @param scene Informs the listener that scene is activated. 
            */
        virtual void OnSceneActivated(Scene* scene) = 0;

    protected:
        SceneListener(const SceneListener&);
        SceneListener& operator=(const SceneListener&);
};

/** @} */ // end of Core3D

} // namespace Candera

#endif// Candera_SceneListener_h

