//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Renderable.h"

namespace Candera {

FEATSTD_RTTI_DEFINITION(Renderable, Node)

Renderable::Renderable() :
    Base(),
    m_vertexBuffer(0),
    m_isBatchable(true)
{
}

Renderable::Renderable(const Renderable& rhs) :
    Base(rhs),
    m_vertexBuffer(rhs.m_vertexBuffer),
    m_isBatchable(rhs.m_isBatchable)
{
}

Renderable::~Renderable()
{
}

bool Renderable::IsRenderPrerequisiteFulfilled() const
{
    return (Base::IsRenderPrerequisiteFulfilled() && (m_vertexBuffer != 0) && (m_vertexBuffer->IsUploaded()));
}

}
