//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Query.h"
#include <Candera/System/Diagnostics/Log.h>
#include <Candera/Engine3D/Core/Renderer.h>


namespace Candera {
    using namespace Diagnostics;
    using namespace MemoryManagement;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

    Query::Query(Type queryType) :
    m_queryType(queryType), 
    m_videoMemoryHandle(0),
    m_Context(-1)
    {
    }


    SharedPointer<Query> Query::Create(Type queryType)
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)
            Query* ptr = FEATSTD_NEW(Query)(queryType);
        CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(774, CANDERA_LINT_REASON_CANDERANEW)
            if (ptr == 0) {
                FEATSTD_LOG_ERROR("Query::Create failed, out of memory.");
            }
        Query::SharedPointer sharedPointer(ptr);
        return sharedPointer;
    }

    Query::~Query()
    {
        static_cast<void>(Unload());
    }


    bool Query::Upload()
    {
        return RenderDevice::UploadQuery(*this);
    }


    bool Query::Unload()
    {        
        return RenderDevice::UnloadQuery(*this);
    }


    bool Query::Begin() const
    {
        // via Renderer to keep track of per frame statistics
        return Renderer::BeginQuery(*this);
    }


    bool Query::End() const
    {
        return RenderDevice::EndQuery(*this);
    }


    bool Query::IsResultAvailable() const 
    {
        return RenderDevice::IsQueryResultAvailable(*this);
    }


    UInt32 Query::GetResult() const
    {
        return RenderDevice::GetQueryResult(*this);
    }


    bool Query::IsActive() const
    {
        return RenderDevice::IsQueryActive(*this);
    }

        
}
