//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ProxyTextureImage.h"
#include <CanderaPlatform/Device/Common/Base/ImageSource3D.h>
#include <Candera/Engine3D/Core/Renderer.h>

namespace Candera {

MemoryManagement::SharedPointer<ProxyTextureImage> ProxyTextureImage::Create(ImageSource3D* imageSource, ImageSourceDisposerFn disposer)
{
    CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)
    ProxyTextureImage* ptr = FEATSTD_NEW(ProxyTextureImage)(imageSource, disposer);

    MemoryManagement::SharedPointer<ProxyTextureImage> sharedPointer(ptr);
    return sharedPointer;
}

ProxyTextureImage::ProxyTextureImage(ImageSource3D* imageSource, ImageSourceDisposerFn disposer) :
    Base(),
    m_listener(imageSource, disposer)
{
}

ProxyTextureImage::~ProxyTextureImage()
{
}

bool ProxyTextureImage::Activate(UInt unit /* = 0 */)
{
    if ((m_listener.m_imageSource != 0) && m_listener.m_isSyncEnabled) {
        m_listener.m_imageSource->Sync();
        if (Renderer::IsRenderingCamera()) {
            static_cast<void>(Renderer::AddRendererListener(&m_listener));
        }
    }

    return Base::Activate(unit);
}

TextureImage::TextureTargetType ProxyTextureImage::GetTextureTargetType() const
{
return (m_listener.m_imageSource != 0) ? 
    m_listener.m_imageSource->GetTextureTarget() : 
    TextureImage::Texture2D;
}
Handle ProxyTextureImage::GetVideoMemoryHandle() const
{
return (m_listener.m_imageSource != 0) ? 
    m_listener.m_imageSource->GetVideoMemoryHandle() : 
    0;
}

bool ProxyTextureImage::IsMipMappingEnabled() const
{
return (m_listener.m_imageSource != 0) ? 
    m_listener.m_imageSource->IsMipMappingEnabled() : 
    false;
}

FEATSTD_RTTI_DEFINITION(ProxyTextureImage, TextureImage)

ProxyTextureImage::ProxyTextureRendererListener::ProxyTextureRendererListener(
    ImageSource3D* imageSource, ImageSourceDisposerFn disposer) :
    m_isSyncEnabled(true),
    m_imageSource(imageSource),
    m_disposer(disposer)
{
}

ProxyTextureImage::ProxyTextureRendererListener::~ProxyTextureRendererListener()
{
    // Remove all instances of this listener.
    while (Renderer::RemoveRendererListener(this)) {}

    if (m_disposer != 0) {
        m_disposer(m_imageSource);
    }
    m_imageSource = 0;
    m_disposer = 0;
}

void ProxyTextureImage::ProxyTextureRendererListener::OnNodePreRender(Node* /*node*/)
{
}
void ProxyTextureImage::ProxyTextureRendererListener::OnNodePostRender(Node* /*node*/)
{
    if ((m_imageSource != 0) && m_isSyncEnabled) {
        m_imageSource->OnAccess();
    }
    static_cast<void>(Renderer::RemoveRendererListener(this));
}

}
